# 帳票設計書 7-Segments Report

## 概要

本ドキュメントは、OpenSearchの `_cat/segments` APIが出力するSegments Reportの帳票設計書である。インデックスのLuceneセグメント情報をテキストテーブル形式で出力するCat APIエンドポイントの仕様を定義する。

### 本帳票の処理概要

Segments Reportは、各インデックスの各シャードに含まれるLuceneセグメントの詳細情報を一覧表示する帳票である。セグメント名、ドキュメント数、サイズ、コミット状態などを出力する。

**業務上の目的・背景**：Luceneセグメントの状態を把握することで、マージの必要性判断、ストレージ効率の分析、セグメント数過多によるパフォーマンス劣化の検出に活用する。セグメントレベルの詳細情報は、インデックスの内部構造を理解するために不可欠である。

**帳票の利用シーン**：セグメント数の監視、マージ戦略の評価、ストレージ使用量の詳細分析、削除済みドキュメント率の確認に利用される。

**主要な出力内容**：
1. セグメント識別情報（インデックス名、シャード番号、セグメント名、世代番号）
2. ドキュメント統計（ドキュメント数、削除済みドキュメント数）
3. セグメントサイズとメモリ使用量
4. セグメント状態（コミット済み、検索可能、コンパウンド形式）
5. Luceneバージョン

**帳票の出力タイミング**：ユーザーが `GET /_cat/segments` または `GET /_cat/segments/{index}` エンドポイントにHTTPリクエストを送信した時点で出力される。

**帳票の利用者**：クラスタ管理者、SRE、パフォーマンスエンジニア。

## 帳票種別

一覧表（テキストテーブル形式のセグメント情報一覧）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Cat セグメント | `GET /_cat/segments` | HTTP GETリクエスト |
| - | Cat セグメント（指定） | `GET /_cat/segments/{index}` | HTTP GETリクエスト |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（text/plain）/ JSON（application/json） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A |
| 出力方法 | HTTPレスポンス |
| 文字コード | UTF-8 |

## 帳票レイアウト

### 明細部（全カラム - すべてdefault:true）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | index | インデックス名 | ShardSegments.getShardRouting().getIndexName() | 文字列 |
| 2 | shard | シャード番号 | ShardSegments.getShardRouting().getId() | 数値 |
| 3 | prirep | プライマリ/レプリカ | ShardSegments.getShardRouting().primary() | p/r |
| 4 | ip | ノードIPアドレス | DiscoveryNodes.get(nodeId).getHostAddress() | 文字列 |
| 5 | id | ノードID | ShardSegments.getShardRouting().currentNodeId() | 文字列（default:false） |
| 6 | segment | セグメント名 | Segment.getName() | 文字列 |
| 7 | generation | セグメント世代番号 | Segment.getGeneration() | 右寄せ数値 |
| 8 | docs.count | ドキュメント数 | Segment.getNumDocs() | 右寄せ数値 |
| 9 | docs.deleted | 削除済みドキュメント数 | Segment.getDeletedDocs() | 右寄せ数値 |
| 10 | size | セグメントサイズ | Segment.getSize() | 右寄せバイト値 |
| 11 | size.memory | セグメントメモリ | 固定値 0L | 右寄せバイト値 |
| 12 | committed | コミット済みか | Segment.isCommitted() | 真偽値 |
| 13 | searchable | 検索可能か | Segment.isSearch() | 真偽値 |
| 14 | version | Luceneバージョン | Segment.getVersion() | 文字列 |
| 15 | compound | コンパウンド形式か | Segment.isCompound() | 真偽値 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| index | インデックス名パターン | No |
| local | ローカルクラスタ状態を使用 | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| - | `s` パラメータで任意指定可能 | 任意 |

### 改ページ条件

改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| データソース | 用途 | 取得方法 |
|-----------|------|---------|
| ClusterStateResponse | ノード情報・ルーティングテーブル | ClusterStateRequest（nodes=true, routingTable=true） |
| IndicesSegmentResponse | セグメント情報 | IndicesSegmentsRequest |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| size.memory | 固定値 0L | なし | 現在のバージョンではセグメントメモリは常に0 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[GET /_cat/segments リクエスト受信] --> B[doCatRequest]
    B --> C[ClusterStateRequest 実行]
    C --> D[ResponseLimit チェック]
    D --> E[IndicesSegmentsRequest 実行]
    E --> F[buildTable でテーブル構築]
    F --> G[RestTable.buildResponse]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ResponseLimitBreachedException | インデックス数が制限超過 | "Segments from too many indices requested." | インデックス名を明示的に指定 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | セグメント総数分の行（数百～数万） |
| 目標出力時間 | 数百ミリ秒～数秒 |
| 同時出力数上限 | ResponseLimitSettings.getCatSegmentsResponseLimit() で制限可能 |

## セキュリティ考慮事項

- `allowSystemIndexAccessByDefault()` が `true` に設定されている。
- `isRequestLimitCheckSupported()` が `true` に設定されており、レスポンス制限チェックが有効。

## 備考

- size.memory は現在のバージョンでは固定値0Lが設定されている（行194）。
- ResponseLimit チェックはルーティングテーブルのインデックス数に基づく。
- 4重ネストのループ（インデックス→シャード→シャードセグメント→セグメント）でテーブル行を構築。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RestSegmentsAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestSegmentsAction.java` | 行145-165: getTableWithHeader() で15カラムの定義 |
| 1-2 | Segment.java | `server/src/main/java/org/opensearch/index/engine/Segment.java` | セグメントデータ構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestSegmentsAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestSegmentsAction.java` | 行100-127: doCatRequest() で2段階のAPI呼び出し |

**主要処理フロー**:
1. **行101-109**: ClusterStateRequest（nodes=true, routingTable=true, indices指定）
2. **行114**: validateRequestLimit() でレスポンス制限チェック
3. **行115-116**: IndicesSegmentsRequest 実行
4. **行121**: buildTable() 呼び出し

#### Step 3: テーブル構築ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RestSegmentsAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestSegmentsAction.java` | 行167-209: buildTable() で4重ネストループ |

### プログラム呼び出し階層図

```
AbstractCatAction.prepareRequest()
    |
    +-- RestSegmentsAction.doCatRequest() [行100]
           |
           +-- client.admin().cluster().state() [行111]
           |      |
           |      +-- validateRequestLimit() [行114]
           |      +-- client.admin().indices().segments() [行117]
           |             |
           |             +-- buildTable() [行167]
           |                    |
           |                    +-- IndexSegments 反復 [行172]
           |                    +-- IndexShardSegments 反復 [行175]
           |                    +-- ShardSegments 反復 [行178]
           |                    +-- Segment 反復 [行181]
           |
           +-- RestTable.buildResponse()
```

### データフロー図

```
[入力]                       [処理]                         [出力]

GET /_cat/segments   --->  ClusterStateRequest         --->  テキストテーブル
GET /_cat/segments/{idx}      |                              (セグメント数分の行)
                              v
                       ClusterStateResponse
                       (ノード情報 + ルーティング)
                              |
                       IndicesSegmentsRequest
                              |
                              v
                       IndicesSegmentResponse
                       (IndexSegments → ShardSegments → Segment)
                              |
                              v
                       buildTable() → Table
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestSegmentsAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestSegmentsAction.java` | ソース | Segments Report メイン処理 |
| Segment.java | `server/src/main/java/org/opensearch/index/engine/Segment.java` | ソース | セグメントデータ構造 |
| IndexSegments.java | `server/src/main/java/org/opensearch/action/admin/indices/segments/IndexSegments.java` | ソース | インデックスセグメント |
| IndexShardSegments.java | `server/src/main/java/org/opensearch/action/admin/indices/segments/IndexShardSegments.java` | ソース | シャードセグメント |
| ShardSegments.java | `server/src/main/java/org/opensearch/action/admin/indices/segments/ShardSegments.java` | ソース | シャードのセグメント一覧 |
| ResponseLimitSettings.java | `server/src/main/java/org/opensearch/common/breaker/ResponseLimitSettings.java` | ソース | レスポンス制限設定 |
